package com.github.wxiaoqi.security.common.constant;

import cn.hutool.core.date.format.FastDateFormat;

import java.time.format.DateTimeFormatter;

/**
 * Created by ace on 2017/8/29.
 */
public class CommonConstants {
    public static final Integer SYS_TRUE = 1;
    public static final Integer SYS_FALSE = 0;
    public static final Integer SYS_ZREO = 0;
    public static final Integer SYS_JSON_TRUE = 200;
    public final static String RESOURCE_TYPE_MENU = "menu";
    public final static String RESOURCE_TYPE_BTN = "button";
    // 用户token异常
    public static final Integer EX_USER_INVALID_CODE = 40101;
    public static final Integer EX_USER_PASS_INVALID_CODE = 40001;
    // 客户端token异常
    public static final Integer EX_CLIENT_INVALID_CODE = 40301;
    public static final Integer EX_CLIENT_FORBIDDEN_CODE = 40331;
    public static final Integer EX_OTHER_CODE = 500;
    public static final String CONTEXT_KEY_USER_TYPE = "currentUserType";
    public static final String CONTEXT_KEY_USER_ID = "currentUserId";
    public static final String CONTEXT_KEY_USERNAME = "currentUserName";
    public static final String CONTEXT_KEY_USER_NAME = "currentUser";
    public static final String CONTEXT_KEY_USER_TOKEN = "currentUserToken";
    public static final String JWT_KEY_USER_ID = "userId";
    public static final String JWT_KEY_NAME = "name";

    // 时间相关
    public static final String DEFAULT = "yyyy/MM/dd";
    public static final String YM = "yyyy/MM";
    public static final String YMR_SLASH = "yyyy-MM-dd";
    public static final String NO_SLASH = "yyyyMMdd";
    public static final String YM_NO_SLASH = "yyyyMM";
    public static final String DATE_TIME = "yyyy/MM/dd HH:mm:ss";
    public static final String DATE_TIME_NO_SLASH = "yyyyMMddHHmmss";
    public static final String DATE_HM = "yyyy/MM/dd HH:mm";
    public static final String TIME = "HH:mm:ss";
    public static final String HM = "HH:mm";
    public static final String LONG_TIME = "HHmmss";
    public static final String SHORT_TIME = "HHmm";
    public static final String DATE_TIME_LINE = "yyyy-MM-dd HH:mm:ss";
    public static final String HOUR_MINUTE = "mm:ss";

    public static final DateTimeFormatter DATE_TIME_LINE_FORMATTER = DateTimeFormatter.ofPattern(DATE_TIME_LINE);
    public static final DateTimeFormatter YMR_SLASH_FORMATTER = DateTimeFormatter.ofPattern(YMR_SLASH);
    public static final org.joda.time.format.DateTimeFormatter YMR_SLASH_FORMATTER_JODA = org.joda.time.format.DateTimeFormat.forPattern(YMR_SLASH);
    public static final FastDateFormat HOUR_MINUTE_FORMATTE_HUTOOL = FastDateFormat.getInstance(HOUR_MINUTE);

}
