package com.xxfc.platform.vehicle.biz;



import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.entity.VehicleUseTime;
import com.xxfc.platform.vehicle.mapper.VehicleUseTimeMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;


@Service
@Slf4j
public class VehicleUseTimeBiz extends BaseBiz<VehicleUseTimeMapper, VehicleUseTime> {



     public  void  addOrUpd(VehicleUseTime vehicleUseTime){
         String vehicleId = vehicleUseTime.getVehicleId();
         if (StringUtils.isBlank(vehicleId) ){
             throw  new BaseException("参数不能为空", ResultCode.FAILED_CODE);
         }
         Example example = new Example(VehicleUseTime.class);
         example.createCriteria().andEqualTo("vehicleId",vehicleId).andEqualTo("status",1);
         List<VehicleUseTime> list = selectByExample(example);
         if (list.size() > 0){
             VehicleUseTime vehicleUseTime1 = list.get(0);
             vehicleUseTime.setId(vehicleUseTime1.getId());
             updateSelectiveById(vehicleUseTime);
         }else {
             Integer companyId = vehicleUseTime.getCompanyId() == null ? 0 :vehicleUseTime.getCompanyId();
             if ( companyId == 0){
                 throw  new BaseException("参数不能为空", ResultCode.FAILED_CODE);
             }
             insertSelective(vehicleUseTime);
         }
     }











}
