package com.xxfc.platform.vehicle.biz;



import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.entity.SysLog;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleUseTime;
import com.xxfc.platform.vehicle.mapper.SysLogMapper;
import com.xxfc.platform.vehicle.mapper.VehicleUseTimeMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;


@Service
@Slf4j
public class SysLogBiz extends BaseBiz<SysLogMapper, SysLog> {



    @Autowired
    VehicleBiz vehicleBiz;



     public  void  addLog(SysLog sysLog){
         String vehicleId = sysLog.getVehicleId();
         if (StringUtils.isBlank(vehicleId) ){
             throw  new BaseException("参数不能为空", ResultCode.FAILED_CODE);
         }
         Vehicle vehicle = vehicleBiz.selectById(vehicleId);
         if (vehicle == null ){
             throw  new BaseException("商品不存在", ResultCode.FAILED_CODE);
         }
         sysLog.setComapnyId(vehicle.getManageCompanyId());
         insertSelective(sysLog);
     }


     public  void  vehicleLog(Vehicle vehicle){
         try {
             SysLog sysLog = new SysLog();
             sysLog.setOperateType(vehicle.getState());
             sysLog.setVehicleId(vehicle.getId());
             sysLog.setType(3);
             sysLog.setOperation("特惠租车上下架商品");
             addLog(sysLog);
         }catch (Exception e){
             e.printStackTrace();
         }
     }











}
