package com.xxfc.platform.vehicle.pojo.vo;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xxfc.platform.vehicle.entity.VehicleApply;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class VehicleApplyVo extends VehicleApply {


    @ApiModelProperty("店铺名称")
    String companyName;

    @ApiModelProperty("品牌名称")
    String brandName;


    @ApiModelProperty("型号名称")
    String categoryName;


    public  String  getBrandName(){
        if (StringUtils.isBlank(brandName)){
            String changeJson = this.getChangeJson();
            if (StringUtils.isNotBlank(changeJson)){
                JSONObject jsonObject = JSONObject.parseObject(changeJson);
                brandName = jsonObject.getString("brandName");
            }
        }
        return  brandName;
    }


    public  String  getCategoryName(){
        if (StringUtils.isBlank(categoryName)){
            String changeJson = this.getChangeJson();
            if (StringUtils.isNotBlank(changeJson)){
                JSONObject jsonObject = JSONObject.parseObject(changeJson);
                categoryName = jsonObject.getString("categoryName");
            }
        }
        return  categoryName;
    }
}
