package com.xxfc.platform.vehicle.pojo.vo;


import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.entity.VehiclePublishReceive;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class ReceiveVo extends VehiclePublishReceive {



    @ApiModelProperty("总数")
    Long number;


    @ApiModelProperty("待确认数量")
    Long waitNumber;


    @ApiModelProperty("确认数量")
    Long confirmNumber;


    @ApiModelProperty("拒绝数量")
    Long refusedNumber;


    private  BigDecimal payAmount;

    private  BigDecimal goodsAmount;

    private  BigDecimal refusedAmount;


    @ApiModelProperty("按钮状态：1-待确认；2-已确认；3-已完成;4-已取消")
    private  Integer buttonState;


    @ApiModelProperty("发布公司")
    BranchCompany publishCompany;


    @ApiModelProperty("需求id")
    private  Integer publishId;

    @ApiModelProperty("类型：1-我要车；2-我有车")
    private  Integer type;


    @ApiModelProperty("开始时间")
    private  Long startTime;


    @ApiModelProperty("结束时间")
    private  Long endTime;


    @ApiModelProperty("状态str")
    private  String statusStr;

    @ApiModelProperty("接单ids")
    private String ids;

    private List<VehiclePublishGoodsVo>  publishGoodsVos;

    private  List<VehiclePublishReceiveVo> publishReceiveVos;




}
