package com.xxfc.platform.order.pojo.order;

import com.xxfc.platform.order.entity.*;
import com.xxfc.platform.vehicle.entity.BookRecordUpdateLog;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderPageVO extends BaseOrder {
    public static final String TYPE = "type=";
    public static final String NO = "no=";

    OrderRentVehicleDetail orderRentVehicleDetail;

    OrderTourDetail orderTourDetail;

    OrderMemberDetail orderMemberDetail;
    OrderActiveDetail orderActiveDetail;
    List<VehicleUserLicense> vehicleUserLicenses;

    //更换还车公司记录
    List<BookRecordUpdateLog> bookRecordUpdateLogs;

    /**
     * 订单最终支付金额：扣除所有费用之后
     */
    private BigDecimal orderRealAmount;

    /**
     * 用户名
     */
    private String username;
    //用户姓名
    private String realName;

    private String startCompanyName;

    private String endCompanyName;
    //用户手机号
    private String telephone;
    // "用户职位名称"
    private  String positionName;
    //订单违约金
    private String dedDetailDTO;
    //订单延长还车，不计免赔额
    private String delayVehicleDetail;
    /**
     * 車輛編碼
     */
    private Integer code;

    /**
     * 是否是用户匹配公司
     */
    private boolean userCompanyStatus = false;

    /**
     * 车牌
     */
    private String vehicalNumberPlat;

    private String qrcodeStr;

    /**
     * 违章预备金
     */
    private BigDecimal illegalReserve;

    /**
     * 出交车记录
     */
    private OrderVehicleCrosstownDto orderVehicleCrosstownDto;

    private List<OrderItem> items;

    private List<OrderPersonInsurance> insurances;

    public void setQrcodeStr(String prefix) {
        this.qrcodeStr = prefix+ "?"+ TYPE+ getType()+ "&"+ NO+ getNo();
    }
}
