package com.xxfc.platform.order.entity.inter;

import cn.hutool.core.collection.CollUtil;
import com.xxfc.platform.order.contant.enumerate.ItemTypeEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderItem;

import java.util.List;

public interface OrderItemInter {
    List<OrderItem> getItems();

    void setItems(List<OrderItem> items);

    default OrderItem getItemByTypeEnum(ItemTypeEnum itemTypeEnum) {
        for(OrderItem item: getItems()) {
            if(itemTypeEnum.getCode().equals(item.getType())) {
                return item;
            }
        }
        return null;
    }

    default List<OrderItem> getItemsByTypeEnum(ItemTypeEnum itemTypeEnum) {
        List<OrderItem> returnItems = CollUtil.newArrayList();
        for(OrderItem item: getItems()) {
            if(itemTypeEnum.getCode().equals(item.getType())) {
                returnItems.add(item);
            }
        }
        return returnItems;
    }

}
