package com.xxfc.platform.order.entity;

import lombok.Data;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.math.BigInteger;

@Data
@Table(name = "order_violation")
public class OrderViolation {

    @Id
    @GeneratedValue(generator ="JDBC")
    private Integer id;

    /**
     * 违章总金额
     */
    @Column(name="price")
    private BigDecimal price;


    /**
     * 租车订单id
     */
    @Column(name = "detail_id")
    private Integer detailId;

    /**
     * 违章截图
     */
    @Column(name = "picture")
    private String picture;


    private String violateJson;

    /**
     * 创建人id
     */
    @Column(name = "crt_user_id")
    private Integer crtUserId;

    /**
     * 创建人姓名
     */
    @Column(name = "crt_name")
    private String crtName;

    /**
     * 创建人host
     */
    @Column(name = "crt_host")
    private String crtHost;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private BigInteger crtTime;

    /**
     * 修改时间
     */

    @Column(name = "upd_time")
    private BigInteger updTime;

    /**
     * 修改人id
     */
    @Column(name = "upd_user_id")
    private Integer updUserId;

    /**
     * 修改人姓名
     */
    @Column(name = "upd_name")
    private String updName;

    /**
     * 修改人host
     */
    @Column(name = "upd_host")
    private String updHost;
    /**
     * 是否已删除:0-否,1-是
     */
     @Column(name="is_del")
    private Integer isDel;

}
