package com.xxfc.platform.order.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2020/1/6 12:38
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "order_member_view")
@Entity
public class MemberStatistics {
    @Id
    @GeneratedValue(generator = "JDBC")
    private Long id;
    @Column(name = "user_id")
    private Integer userId;
    @Column(name = "real_amount")
    private BigDecimal realAmount;
    @Column(name = "pay_time")
    private Long payTime;
    @Column(name = "order_no")
    private String orderNo;
    /**
     * 0:首次购买 1：续费 2：激活
     */
    @Column(name = "behavior_type")
    private Integer behaviorType;
    @Column(name = "member_level")
    private Integer memberLevel;
    @Column(name = "parent_id")
    private Integer parentId;
    /**
     * 是否是第一时时间成为会员
     */
    @Column(name = "is_first_time_member")
    private Integer isFirstTimeMember;
}
