package com.xxfc.platform.app.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.xxfc.platform.app.biz.CofigBiz;
import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.campsite.feign.CampsiteFeign;
import com.xxfc.platform.tour.feign.TourFeign;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("home")
@IgnoreClientToken
@Slf4j
public class AppHomeController extends BaseController<CofigBiz,Cofig> {


    @Autowired
    CampsiteFeign campsiteFeign;

    @Autowired
    TourFeign tourFeign;

    @Autowired
    VehicleFeign vehicleFeign;



    @RequestMapping(value ="/app/unauth/goodList",method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse<List<GoodDataVO>> goodList(
            @RequestParam(value = "page", defaultValue = "1") Integer page,
            @RequestParam(value = "limit",defaultValue = "4") Integer limit,
            @RequestParam(value = "type",defaultValue = "1") Integer type,
            @RequestParam(value = "longitude", required = false) Double longitude,
            @RequestParam(value = "latitude", required = false) Double latitude
    ){
        List<GoodDataVO> list=new ArrayList<>();
        if (type==2){
            list=tourFeign.goodList(page,limit);
        }else if (type==3){
            //list=campsiteFeign.goodList(page,limit);
            list=campsiteFeign.goodList(page,limit,longitude,latitude);
        }else if (type==4){
            return vehicleFeign.goodList(page,limit);
        }
        return  new ObjectRestResponse<>().rel(true).data(list);
    }
}