package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.BranchCompanyBannerBiz;
import com.github.wxiaoqi.security.admin.dto.BranchCompanyBannerDTO;
import com.github.wxiaoqi.security.admin.entity.BranchCompanyBanner;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/companyBanner")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"店铺Banner"})
public class AdminBranchCompanyBannerController extends BaseController<BranchCompanyBannerBiz, BranchCompanyBanner> implements UserRestInterface {

    @Autowired
    UserFeign userFeign;


    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }

    @GetMapping("selectList")
    @ApiModelProperty("店铺Banner列表")
    public  ObjectRestResponse selectList(BranchCompanyBannerDTO branchCompanyBannerDTO) {
        setPowerData(branchCompanyBannerDTO);
     return  baseBiz.selectList(branchCompanyBannerDTO);
    }






}
