package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.BaseOrderAcceptDetailedBiz;
import com.github.wxiaoqi.security.admin.dto.OrderWaterDTO;
import com.github.wxiaoqi.security.admin.entity.BaseOrderAcceptDetailed;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/accept")
@Api(tags = {"拥金比例"})
public class AdminBaseOrderAcceptDetailedController extends BaseController<BaseOrderAcceptDetailedBiz, BaseOrderAcceptDetailed> implements UserRestInterface {


    @Autowired
    UserFeign userFeign;


    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }




    @PostMapping("orderWater")
    @ApiModelProperty("设置")
    public  ObjectRestResponse orderWater(@RequestBody OrderWaterDTO orderWaterDTO) {
       baseBiz.orderWater(orderWaterDTO);
       return ObjectRestResponse.succ();
    }



}
