package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.BaseMemberLevelBiz;
import com.github.wxiaoqi.security.admin.dto.BaseMemberLevelFindDTO;
import com.github.wxiaoqi.security.admin.entity.BaseMemberLevel;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2020/6/24 16:11
 */
@RestController
@RequestMapping("/backstage/baseMemberLevel")
public class AdminBaseMemberLevelController extends BaseController<BaseMemberLevelBiz, BaseMemberLevel> {



    @GetMapping("/selectList")
    public ObjectRestResponse selectList(BaseMemberLevelFindDTO userMemberLevelFindDTO) {
        return baseBiz.selectList(userMemberLevelFindDTO);
    }

    @PostMapping("/save")
    public ObjectRestResponse<Void> saveUserMemberLevel(@RequestBody BaseMemberLevel baseMemberLevel) {
        baseBiz.saveOrUpdateBaseUserMemberLevel(baseMemberLevel);
        return ObjectRestResponse.succ();
    }

    @DeleteMapping("/delete/{id}/{changeLevel}")
    public ObjectRestResponse<Void> deleteUserMemberLevel(@PathVariable(value = "id") Integer id,
                                                          @PathVariable(value = "changeLevel") Integer changeLevel) {
        baseBiz.deleteUserMemberLevelById(id, changeLevel);
        return ObjectRestResponse.succ();
    }

    @GetMapping("/detail/{id}")
    public ObjectRestResponse<BaseMemberLevel> findUserMemberLevelDetail(@PathVariable(value = "id") Integer id) {
        BaseMemberLevel userMemberLevel = baseBiz.getUserMemberLevelDetailById(id);
        return ObjectRestResponse.succ(userMemberLevel);
    }


    @GetMapping("/maxLevel")
    public ObjectRestResponse getMaxLevel() {
        return ObjectRestResponse.succ(baseBiz.getMaxLevel());
    }


    @GetMapping("/getAll")
    public ObjectRestResponse getAll(BaseMemberLevelFindDTO userMemberLevelFindDTO) {
        return ObjectRestResponse.succ(baseBiz.getList(userMemberLevelFindDTO));
    }
}