package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.dto.AppraiseLabeInfoDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.admin.biz.AppraiseLabelInfoBiz;
import com.github.wxiaoqi.security.admin.entity.AppraiseLabelInfo;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("app/appraiseLabelInfo")
public class AppraiseLabelInfoController extends BaseController<AppraiseLabelInfoBiz, AppraiseLabelInfo> {

    @GetMapping("tag/selectList")
    @ApiModelProperty("标签列表")
    public ObjectRestResponse applySelectList(AppraiseLabeInfoDTO appraiseLabeInfoDTO) {
        return  baseBiz.selectAppList(appraiseLabeInfoDTO);
    }
}