package com.github.wxiaoqi.security.admin.vo;

import com.github.wxiaoqi.security.admin.constant.enumerate.CompanyWalletSourceEnum;
import com.github.wxiaoqi.security.admin.entity.BaseOrderRevenue;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 9:20
 */
@Data
public class BaseOrderRevenueVo extends BaseOrderRevenue {

    private BigDecimal withdrawAmount;

    private String showTypeStr;

    public String getShowTypeStr() {
        String type = this.getType();
        showTypeStr = "";
        if (StringUtils.isNotBlank(type)) {
            String[] values = type.split(",");
            List<String> list = Arrays.asList(values);
            if (list.contains(CompanyWalletSourceEnum.VEHICLE.getCode()+"")) {
                if (list.contains(CompanyWalletSourceEnum.WATER.getCode()+"")){
                    showTypeStr = "租赁费+上级拥金";
                }else {
                    showTypeStr = "租赁费";
                }
            } else if (list.contains(CompanyWalletSourceEnum.WATER.getCode()+"")) {
                if (list.contains(CompanyWalletSourceEnum.VEHICLE.getCode()+"")){
                    showTypeStr = "租赁费+上级拥金";
                }else {
                    showTypeStr = "上级拥金";
                }
            } else if (list.contains(CompanyWalletSourceEnum.REGULATION.getCode()+"")) {
                showTypeStr = "违章金";
            }
        }
        return showTypeStr;
    }

}
