package com.github.wxiaoqi.security.admin.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

@Table(name = "base_user")
@Data
public class User {

    public static final int BIZ_TYPE_OPERATE = 1;
    public static final int BIZ_TYPE_BUSINESS = 2;

    @Id
    @GeneratedValue(generator = "JDBC")//此处加上注解
    private Integer id;


    @Column(name = "app_user_id")
    private Integer appUserId;

    private String username;

    private String password;

    private String name;

    private String birthday;

    private String address;

    @Column(name = "mobile_phone")
    private String mobilePhone;

    @Column(name = "tel_phone")
    private String telPhone;

    private String email;

    private String sex;

    private String type;

    @Column(name = "status")
    private Integer status;

    @Column(name = "zone_id")
    @ApiModelProperty("片区id")
    private Integer zoneId;


    @Column(name = "corporation_id")
    @ApiModelProperty("公司id")
    private Long corporationId;

    @Column(name = "company_id")
    @ApiModelProperty("门店id")
    private Integer companyId;

    private String description;

    @Column(name = "crt_time")
    private Date crtTime;

    @Column(name = "crt_user")
    private String crtUser;

    @Column(name = "crt_name")
    private String crtName;

    @Column(name = "crt_host")
    private String crtHost;

    @Column(name = "upd_time")
    private Date updTime;

    @Column(name = "upd_user")
    private String updUser;

    @Column(name = "upd_name")
    private String updName;

    @Column(name = "upd_host")
    private String updHost;

    @Column(name = "data_all")
    private Integer dataAll;

    @Column(name = "data_zone")
    private String dataZone;

    @Column(name = "data_company")
    private String dataCompany;


    @Column(name = "data_corporation")
    private String dataCorporation;

    @Column(name = "biz_type")
    private Integer bizType;

    @Column(name = "is_del")
    private Integer isDel;

    private String attr1;

    private String attr2;

    private String attr3;

    private String attr4;

    private String attr5;

    private String attr6;

    private String attr7;

    private String attr8;

    @Transient
    private List<Integer> companyIds;

}