package com.github.wxiaoqi.security.admin.dto;


import com.github.wxiaoqi.security.common.vo.DataInter;
import com.github.wxiaoqi.security.common.vo.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 门店收支明细DTO
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/25 14:53
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CompanyWalletDTO extends PageParam implements DataInter {


   private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");

    @ApiModelProperty("门店")
    private  Integer companyId;


    @ApiModelProperty("企业")
    private  Integer branchId;

    @ApiModelProperty("月份")
    private  String month;



    List<Integer> dataCorporationIds;

    List<Integer> dataCompanyIds;

    Integer bizType;


    public  String getMonth(){
        if (StringUtils.isBlank(month)){
            month=dateFormat.format(new Date());
        }
        return  month;
    }







}
