package com.xxfc.platform.order.biz;

import com.xxfc.platform.order.contant.enumerate.ItemTypeEnum;
import org.springframework.stereotype.Service;

import com.xxfc.platform.order.entity.OrderItem;
import com.xxfc.platform.order.mapper.OrderItemMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.math.BigDecimal;

/**
 * 购房车提交表单
 *
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-23 17:33:06
 */
@Service
public class OrderItemBiz extends BaseBiz<OrderItemMapper,OrderItem> {
    public OrderItem initOrderItem(BigDecimal price, Integer num, String name, Integer goodId, ItemTypeEnum itemTypeEnum, String detail){
        return new OrderItem(){{
            setMetaUnitPrice(price);
            setUnitPrice(price);
            setBuyNum(num);
            setTotalNum(num);
            setAwardNum(0);
            setCutNum(0);
            setCouponAmount(BigDecimal.ZERO);
            setName(name);
            setGoodId(goodId);
            setType(itemTypeEnum.getCode());
            setDetail(detail);
        }};
    }

    public OrderItem initOrderItem(BigDecimal price, Integer num, String name, Integer goodId, ItemTypeEnum itemTypeEnum){
        return initOrderItem(price, num, name, goodId, itemTypeEnum, null);
    }
}