package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum DepositRefundStatus {
    INITIATEREFUND(1,"发起退还"),
    REFUNDARRIVAL(2,"退还到账"),
    VIOLATIONARRIVAL (3,"违章到账"),
    FIXLOSS(4,"定损中"),
    FIXLOSSREFUND(5,"定损押金退还"),
    FIXLOSSREFUNDARRIVAL(6,"定损押金已到账"),
    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();

    DepositRefundStatus(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }
}
