package com.xxfc.platform.vehicle.entity;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * 出车记录
 */
@Table(name = "vehicle_departure_log")
@Data
public class VehicleDepartureLog {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "JDBC")
    Integer id;
    /**
     * 车辆ID
     */
    String vehicleId;
    /**
     * 用途
     */
    @Column(name = "`use`")
    String use;
    /**
     * 使用人
     */
    @Column(name = "`user`")
    String user;
    /**
     * 使用人电话
     */
    String userTel;
    /**
     * 验车人
     */
    String checkMan;
    /**
     * 验车人电话
     */
    String checkManTel;
    /**
     * 收车人
     */
    String recycleMan;
    /**
     * 收车人电话
     */
    String recycleManTel;
    /**
     * 出车时间
     */
    Date departureTime;
    /**
     * 还车时间
     */
    Date arrivalTime;
    /**
     * 出车开始的公里数
     */
    Integer mileageStart;
    /**
     * 出车结束的公里数
     */
    Integer mileageEnd;
    /**
     * 出车分公司
     */
    Integer departureBranchCompanyId;
    /**
     * 预计还车分公司
     */
    Integer expectArrivalBranchCompanyId;
    /**
     * 还车分公司
     */
    Integer arrivalBranchCompanyId;
    Date createTime;
    Date updateTime;

    Integer state;

    /**
     * 预约记录id
     */
    Integer bookRecordId;
}
