package com.xxfc.platform.universal.controller;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.universal.dto.ImgDTO;
import com.xxfc.platform.universal.dto.UploadImgDTO;
import com.xxfc.platform.universal.service.UploadService;
import com.xxfc.platform.universal.utils.ImgBase64Util;
import com.xxfc.platform.universal.utils.PublicMsg;
import com.xxfc.platform.universal.vo.Ueditor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 图片上传
 */
@RestController
@RequestMapping("file")
@IgnoreUserToken
@Slf4j
public class UploadController{

       @Autowired
       UploadService uploadService;

      private static Integer MAX_DRIVING_LICENSE_SIZE = 10 * 1024 * 1024;//10M

     @RequestMapping(value = "/app/unauth/upload", method = RequestMethod.POST)
    public JSONObject upload(
            @RequestParam("file") MultipartFile file,
            @RequestParam(value = "prefix",defaultValue = "app")String prefix
     )throws Exception {
        String contentType = file.getContentType();   //图片文件类型
//        String fileName = file.getOriginalFilename();  //图片名字
       /* if (!contentType.equals("image/jpeg") && !contentType.equals("image/gif")&&!contentType.equals("image/png")) {
            return JsonResultUtil.createFailedResult(2001,"格式不对!!!");
        }*/
        if (file.getSize() > MAX_DRIVING_LICENSE_SIZE) {
            return JsonResultUtil.createFailedResult(2002,"大小超过限制!!!");
        }
        return JsonResultUtil.createSuccessResultWithObj(uploadService.uploadFile(file,prefix));
    }

    @RequestMapping(value = "/app/unauth/admin/upload", method = RequestMethod.POST)
    public JSONObject uploads(
            @RequestParam("file") MultipartFile file,
            @RequestParam(value = "prefix",defaultValue = "admin")String prefix
    )throws Exception {
        String contentType = file.getContentType();   //图片文件类型
//        String fileName = file.getOriginalFilename();  //图片名字
       /* if (!contentType.equals("image/jpeg") && !contentType.equals("image/gif")&&!contentType.equals("image/png")) {
            return JsonResultUtil.createFailedResult(2001,"格式不对!!!");
        }*/
        if (file.getSize() > MAX_DRIVING_LICENSE_SIZE) {
            return JsonResultUtil.createFailedResult(2002,"大小超过限制!!!");
        }
        return JsonResultUtil.createSuccessResultWithObj(uploadService.uploadFile(file,prefix));
    }

    @IgnoreUserToken
    @RequestMapping(value = "/app/unauth/download", method = RequestMethod.GET) //匹配的是href中的download请求
    public ResponseEntity<byte[]> download(@RequestParam("realFileRelPath") String realFileRelPath) throws Exception {
        return uploadService.downloadFile(realFileRelPath);
    }

    @RequestMapping(value = "/app/unauth/uploadFiles", method = RequestMethod.POST)
    public JSONObject uploadFiles(
            @RequestParam("files") MultipartFile[] files,
            @RequestParam(value = "prefix",defaultValue = "app")String prefix,
            HttpServletRequest request
        )throws Exception {
        if(files!=null&&files.length>0){
            String urls="";
            for(int i = 0;i<files.length;i++){
                MultipartFile file = files[i];
                //保存文件
                String contentType = file.getContentType();
                if (file.getSize() > MAX_DRIVING_LICENSE_SIZE) {
                    log.error("大小超过限制!!!");
                    continue;
                }
                String path=uploadService.uploadFile(file,prefix);
                if(StringUtils.isBlank(urls)){
                    urls+=path;
                }else {
                    urls+=","+path;
                }

            }
            return JsonResultUtil.createSuccessResultWithObj(urls);

        }
        return JsonResultUtil.createDefaultFail();

    }

    @PostMapping( value = "/app/unauth/uploads")
    public JSONObject uploads(@RequestBody UploadImgDTO uploadimgDTO)throws Exception {
            if (uploadimgDTO==null){
                JsonResultUtil.createDefaultFail();
            }
            String prefix=uploadimgDTO.getPrefix();
            if(StringUtils.isBlank(prefix)){
                prefix="app";
            }
            List<ImgDTO> imgDTOS=uploadimgDTO.getImgs();
            List<Map<String,Object>> list=new ArrayList<>();
            if (imgDTOS.size()>0){
                for (ImgDTO imgDTO:imgDTOS){
                    String  imgbese =imgDTO.getImgFile();
                    String  fileName =imgDTO.getFileName();
                    Map<String,Object> map=new HashMap<>();
                    if(StringUtils.isNotBlank(imgbese)){
                        String url=uploadService.uploadImg(imgbese,prefix);
                        map.put("imgUrl",url);
                        map.put("fileName",fileName);
                        list.add(map);
                    }
                }
            }
            return JsonResultUtil.createSuccessResultWithObj(list);

        }




    //以下是图片上传的方法
    @RequestMapping(value="/app/unauth/ueditor")
    @ResponseBody
    public String ueditor(HttpServletRequest request) {

        return PublicMsg.UEDITOR_CONFIG;
    }

    @RequestMapping(value="/app/unauth/ueditor", method = RequestMethod.POST)
    public Ueditor imgUpload(MultipartFile upfile) throws Exception {
        Ueditor ueditor = new Ueditor();
        ueditor.setUrl(uploadService.uploadFile(upfile,"admin"));
        ueditor.setOriginal(upfile.getOriginalFilename());
        ueditor.setState("SUCCESS");
        ueditor.setTitle(upfile.getOriginalFilename());
        return ueditor;
    }
}

