package com.xxfc.platform.order.jobhandler;

import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.entity.DailyOrderStatistics;
import com.xxfc.platform.order.mapper.BaseOrderMapper;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 *  每天2定时统计前一天的数据
 */
@JobHandler(value = "baseOrderStatistics")
@Component
@Slf4j
public class BaseOrderStatisticsJobHandler extends IJobHandler {
    @Autowired
    private BaseOrderBiz baseOrderBiz;

    @Override
    public ReturnT<String> execute(String s) throws Exception {
        try {
        DailyOrderStatistics dailyOrderStatistics= baseOrderBiz.getTotalOrder();
        
            ReturnT returnT = new ReturnT(){{
                setCode(100);
                setMsg("成功");
            }};
            return returnT;
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return FAIL;
        } finally {
        }
    }
}
