package com.xxfc.platform.order.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.user.UserInfoBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.entity.OrderUserLicense;
import com.xxfc.platform.order.entity.OrderVehicleCrosstown;
import com.xxfc.platform.order.mapper.OrderVehicaleCrosstownMapper;
import com.xxfc.platform.order.pojo.mq.OrderMQDTO;
import com.xxfc.platform.order.pojo.order.OrderVehicleCrosstownDto;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class OrderVehicalCrosstownBiz extends BaseBiz<OrderVehicaleCrosstownMapper, OrderVehicleCrosstown> {

    @Autowired
    OrderVehicalCrosstownBiz orderVehicalCrosstownBiz;

    @Autowired
    OrderUserLicenseBiz orderUserLicenseBiz;

    @Autowired
    UserInfoBiz userInfoBiz;
    @Autowired
    VehicleFeign vehicleFeign;
    @Autowired
    UserFeign userFeign;
    @Autowired
    private OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    BaseOrderBiz baseOrderBiz;

    public OrderVehicleCrosstown get(Integer id){
        return selectById(id);
    }

    public List<OrderVehicleCrosstownDto> selectByOrderId(OrderVehicleCrosstownDto orderVehicleCrosstownDto) {
        List<OrderVehicleCrosstownDto> list = mapper.selectByOrderId(orderVehicleCrosstownDto);
        for(OrderVehicleCrosstownDto value : list) {
            if (value.getOrperaterId() != null) {
                ObjectRestResponse<AppUserDTO> objectRestResponse = userFeign.userDetailById(value.getOrperaterId());
                if(objectRestResponse.getData() != null) {
                    value.setUsername(objectRestResponse.getData().getNickname());
                }
            }
            if(value.getUserLicenseId() != null) {
                List<OrderUserLicense> orderUserLicenses = orderUserLicenseBiz.selectByIds(value.getUserLicenseId()).getData();
                if(orderUserLicenses != null && orderUserLicenses.size() > 0) {
                    value.setLicenseIdCard(orderUserLicenses.get(0).getLicenseIdCard());
                    value.setLicenseImg(orderUserLicenses.get(0).getLicenseImg());
                    value.setLicenseName(orderUserLicenses.get(0).getLicenseName());
                    value.setLicensePhone(orderUserLicenses.get(0).getLicensePhone());
                }
            }

        }
        return list;
    }

    public ObjectRestResponse<OrderVehicleCrosstownDto> add(OrderVehicleCrosstownDto orderVehicleCrosstownDto) {
        log.info("添加的参数：orderVehicaleCrosstown = {}", orderVehicleCrosstownDto);
        UserDTO userDTO = userInfoBiz.getAdminUserInfo();
        if (userDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        if (orderVehicleCrosstownDto == null || orderVehicleCrosstownDto.getOrderId() == null ) {
            return ObjectRestResponse.createFailedResult(500, "参数为空！");
        }
        orderVehicleCrosstownDto.setOrperaterId(userDTO.getId());
        BaseOrder baseOrder = baseOrderBiz.selectById(orderVehicleCrosstownDto.getOrderId());
        if(baseOrder == null) {
            return ObjectRestResponse.createFailedResult(500,"订单不存在！");
        }
        OrderRentVehicleDetail orderRentVehicleDetail = orderRentVehicleBiz.selectById(baseOrder.getDetailId());
        List<OrderVehicleCrosstownDto> oldValue = orderVehicalCrosstownBiz.selectByOrderId(orderVehicleCrosstownDto);
        if (oldValue .size() == 1) {
            //已有直接返回
            //交车完成 设置订单状态为出行中
            handleOrderStatus(baseOrder, orderRentVehicleDetail);
            OrderVehicleCrosstownDto vehicleCrosstownDto = new OrderVehicleCrosstownDto();
            BeanUtil.copyProperties(oldValue.get(0), vehicleCrosstownDto, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
            List<OrderUserLicense> orderUserLicenses = orderUserLicenseBiz.selectByIds(oldValue.get(0).getUserLicenseId()).getData();
            if(orderUserLicenses != null && orderUserLicenses.size() > 0) {
                orderVehicleCrosstownDto.setLicenseIdCard(orderUserLicenses.get(0).getLicenseIdCard());
                orderVehicleCrosstownDto.setLicenseImg(orderUserLicenses.get(0).getLicenseImg());
                orderVehicleCrosstownDto.setLicenseName(orderUserLicenses.get(0).getLicenseName());
                orderVehicleCrosstownDto.setLicensePhone(orderUserLicenses.get(0).getLicensePhone());
            }
            RestResponse<Vehicle> restResponse = vehicleFeign.findById(orderRentVehicleDetail.getVehicleId());
            if(restResponse.getData() != null) {
                vehicleCrosstownDto.setVehicleNumberPlat(restResponse.getData().getNumberPlate());
            }
            return ObjectRestResponse.succ(vehicleCrosstownDto);
        } else if(oldValue .size() <= 0) {
            getOrderLicense(orderVehicleCrosstownDto);
            orderVehicalCrosstownBiz.insertSelective(orderVehicleCrosstownDto);
            handleOrderStatus(baseOrder, orderRentVehicleDetail);
            RestResponse<Vehicle> restResponse = vehicleFeign.findById(orderRentVehicleDetail.getVehicleId());
            if(restResponse.getData() != null) {
                orderVehicleCrosstownDto.setVehicleNumberPlat(restResponse.getData().getNumberPlate());
            }
            return ObjectRestResponse.succ(orderVehicleCrosstownDto);
        }
        return ObjectRestResponse.createDefaultFail();
    }

    private void handleOrderStatus(BaseOrder baseOrder, OrderRentVehicleDetail orderRentVehicleDetail) {
        //交车完成 设置订单状态为出行中
        if (baseOrder.getStatus() == 4) {
            //判断是否是今日交车
            baseOrder.setStatus(5);
            baseOrderBiz.updateSelectiveById(baseOrder);
        } else if (baseOrder.getStatus() == 5) {
            baseOrder.setStatus(6);
            baseOrderBiz.updateSelectiveById(baseOrder);
            baseOrderBiz.sendOrderMq(orderRentVehicleDetail, null, null, baseOrder, OrderMQDTO.ORDER_FINISH);
        }
    }

    public void getOrderLicense(OrderVehicleCrosstownDto orderVehicleCrosstownDto) {
        OrderUserLicense orderUserLicense = new OrderUserLicense();
        orderUserLicense.setLicenseIdCard(orderVehicleCrosstownDto.getLicenseIdCard());
        orderUserLicense.setLicenseImg(orderVehicleCrosstownDto.getLicenseImg());
        orderUserLicense.setLicenseName(orderVehicleCrosstownDto.getLicenseName());
        orderUserLicense.setLicensePhone(orderVehicleCrosstownDto.getLicensePhone());
        if(orderUserLicense != null) {
            Integer id = orderUserLicenseBiz.add(orderUserLicense).getData().getId();
            orderVehicleCrosstownDto.setUserLicenseId(id + "");
        }
    }
}
