package com.xxfc.platform.activity.rest.admin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.excel.ExcelImport;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.activity.ActivityApplication;
import com.xxfc.platform.activity.biz.UserCouponBiz;
import com.xxfc.platform.activity.dto.UserCouponFindDTO;
import com.xxfc.platform.activity.dto.UserCouponSendDTO;
import com.xxfc.platform.activity.vo.UserCouponPageVo;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;


/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/23 16:22
 */
@RestController
@RequestMapping("/admin/user_coupon")
public class UserCouponAdminController {

    @Autowired
    private UserCouponBiz userCouponBiz;

    @ApiOperation("领劵列表")
    @GetMapping("/page")
    public ObjectRestResponse<PageDataVO<UserCouponPageVo>> listUserCouponWithPage(UserCouponFindDTO userCouponFindDTO) {
        PageDataVO<UserCouponPageVo> userCouponPage = userCouponBiz.listUserCouponWithPage(userCouponFindDTO);
        return ObjectRestResponse.succ(userCouponPage);
    }

    @PostMapping("/sendcoupon")
    public ObjectRestResponse<Void> sendCoupon(@RequestBody  UserCouponSendDTO userCouponSendDTO){
           userCouponBiz.sendCoupon(userCouponSendDTO);
        return ObjectRestResponse.succ();
    }

    @PostMapping("/import")
    public ObjectRestResponse<Void> importCouponBatch(@RequestParam("couponId") Integer couponId,@RequestPart(name = "file")MultipartFile couponExcel){
        List<String[]> userCounponData = ExcelImport.getExcelData(couponExcel);
        if (userCounponData.size() < 1) {
            return ObjectRestResponse.createFailedResult(1001, "导入不能没数据！！！");
        }
        userCounponData.remove(0);
        userCouponBiz.importUserCoupon(couponId,userCounponData);
        return ObjectRestResponse.succ();
    }

    @ApiOperation("用户劵excel模板下载")
    @GetMapping("/excel_model/dowload")
    public ResponseEntity<byte[]> dowloadUserMemberExcelModel(HttpServletResponse response) {
        // 重置response
        response.reset();
        response.setCharacterEncoding("utf-8");
        response.setContentType("multipart/form-data");
        response.addHeader("Content-Disposition", "attachment;filename=usercoupon.xlsx");
        InputStream inputStream = ActivityApplication.class.getClassLoader().getResourceAsStream("file/usercoupon.xlsx");
        try {
            byte[] bytes = IOUtils.toByteArray(inputStream);
            return ResponseEntity.ok(bytes);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(null);
    }
}
