package com.xxfc.platform.universal.controller;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.universal.entity.Invoice;
import com.xxfc.platform.universal.entity.vo.InvoiceVo;
import com.xxfc.platform.universal.service.InvoiceBiz;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 发票接口
 * @Auther: Administrator
 * @Date: 2019/12/31 09:57
 * @Description:
 */
@RestController
//@IgnoreUserToken
@RequestMapping("/invoice")
@RequiredArgsConstructor(onConstructor_ ={@Autowired} )
public class InvoiceController extends BaseController<InvoiceBiz, Invoice> {


    /**
     * 根据开票代码获取税号
     * @param code
     * @return
     */
    @GetMapping("/dutyParagraph")
    public ObjectRestResponse getDutyParagraphByCode(@RequestParam("code")String code){
        String dutyParagraph = baseBiz.getDutyParagraphByCode(code);
        return ObjectRestResponse.succ(dutyParagraph);
    }

    /**
     * 模糊查询获取公司全名和开票代码
     * @param name
     * @return
     */
    @GetMapping("/corporateName")
    public ObjectRestResponse corporateName(@RequestParam("name")String name){
        List<Map<String, String>> mapList = baseBiz.corporateName(name);
        return ObjectRestResponse.succ(mapList);
    }

    @PostMapping("/invoicing")
    public ObjectRestResponse invoicing(@RequestBody InvoiceVo invoiceVo) throws Exception {
        String invoicing = baseBiz.Invoicing(invoiceVo);
        return ObjectRestResponse.succ(invoicing);
    }

    @GetMapping("/result")
    public ObjectRestResponse invoiceResult(@RequestParam("invoiceSerialNum")String invoiceSerialNum){
      String result=  baseBiz.invoiceResult(invoiceSerialNum);
        return ObjectRestResponse.succ(result);
    }
}
