package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.biz.OrderInvoiceBiz;
import com.xxfc.platform.order.entity.OrderInvoice;
import com.xxfc.platform.order.pojo.dto.OrderInvoiceDto;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 发票记录
 */
@RestController
@RequestMapping(value = "/order/invoice")
public class OrderInvoiceController extends BaseController<OrderInvoiceBiz, OrderInvoice> {

	@PostMapping(value = "/add")
	public ObjectRestResponse add(@RequestBody OrderInvoice orderInvoice) {
		return baseBiz.add(orderInvoice);
	}

	@GetMapping(value = "selectByOrderIds")
	public ObjectRestResponse<List<OrderInvoice>> selectByOrderIds(String orderIds) {
		return baseBiz.selectByIds(orderIds);
	}

	@GetMapping(value = "selectByType")
	public  ObjectRestResponse selectByToken(OrderInvoiceDto orderInvoiceDto) {
		return baseBiz.selectByToken(orderInvoiceDto);
	}

	@GetMapping(value = "getByUser")
	public ObjectRestResponse selectByUserId(OrderInvoiceDto orderInvoiceDto) {
		return baseBiz.selectByUserId(orderInvoiceDto);
	}

	@GetMapping(value = "/getAll")
	public ObjectRestResponse<PageDataVO<OrderInvoice>> getByParam(OrderInvoiceDto orderInvoiceDto) {
		return baseBiz.getByParam(orderInvoiceDto);
	}

}
