package com.xxfc.platform.vehicle.feign;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

@Component
public class AdminInfoFeign {

    @Autowired
    UserFeign userFeign;

    public UserDTO getAdminUserInfo() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        if(request.getHeader("Authorization") !=null) {
            return userFeign.userinfoByToken(request.getHeader("Authorization")).getData();
        }
        return null;
    }
}
