package com.xxfc.platform.order.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 购房车提交表单
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-23 17:33:06
 */
@Data
@Table(name = "order_item")
public class OrderItem implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    /**
     *  item 类型 1--租车车型 2--车损免赔 3--司机费用 4--旅游项目 5--旅游保险 6--会员
     */
    @Column(name = "type")
	@ApiModelProperty(value = "item 类型 1--租车车型 2--车损免赔 3--司机费用 4--旅游项目 5--旅游保险 6--会员")
    private Integer type;
	
	    /**
     *  原单价
     */
    @Column(name = "meta_unit_price")
	@ApiModelProperty(value = "原单价")
    private BigDecimal metaUnitPrice;
	
	    /**
     *  单价
     */
    @Column(name = "unit_price")
	@ApiModelProperty(value = "单价")
    private BigDecimal unitPrice;
	
	    /**
     *  总数  （购买数 + 赠送数）
     */
    @Column(name = "total_num")
	@ApiModelProperty(value = "总数  （购买数 + 赠送数）")
    private Integer totalNum;
	
	    /**
     *  购买数量
     */
    @Column(name = "buy_num")
	@ApiModelProperty(value = "购买数量")
    private Integer buyNum;
	
	    /**
     *  赠送的数量
     */
    @Column(name = "award_num")
	@ApiModelProperty(value = "赠送的数量")
    private Integer awardNum;
	
	    /**
     *  扣减数量  （从购买数里面扣减的数量）
     */
    @Column(name = "cut_num")
	@ApiModelProperty(value = "扣减数量  （从购买数里面扣减的数量）")
    private Integer cutNum;
	
	    /**
     *  商品id 有些为空如车损，免赔等
     */
    @Column(name = "good_id")
	@ApiModelProperty(value = "商品id 有些为空如车损，免赔等")
    private Integer goodId;
	
	    /**
     *  优惠券等扣减的价格
     */
    @Column(name = "coupon_amount")
	@ApiModelProperty(value = "优惠券扣减的价格")
    private BigDecimal couponAmount;
	
	    /**
	 *  真实的总价
	 */
	@Column(name = "real_amount")
	@ApiModelProperty(value = "真实的总价")
	private BigDecimal realAmount;

	/**
	 *  订单id
	 */
	@Column(name = "order_id")
	@ApiModelProperty(value = "订单id")
	private Integer orderId;


	public Integer getCalculateNum() {
		return buyNum - cutNum;
	}

	public BigDecimal getCalculateAmount(Boolean isSetRealAmount) {
		BigDecimal calculateAmount = getUnitPrice().multiply(BigDecimal.valueOf(getCalculateNum()));
		if(isSetRealAmount) {
			setRealAmount(calculateAmount);
		}
		return calculateAmount;
	}

	public BigDecimal handleCouponAmount(BigDecimal couponAmount) {
		BigDecimal realAmountResidue = getRealAmount().subtract(couponAmount);
		//剩余价格小于0  即优惠价格超出本item的实际价格，返回剩余优惠
		if(BigDecimal.ZERO.compareTo(realAmountResidue) > 0) {
			setCouponAmount(getRealAmount());
			setRealAmount(BigDecimal.ZERO);
			return couponAmount.subtract(getCouponAmount());
		}else {
		//剩余价格大于等于0  即优惠价格低于本item的实际价格，返回ZERO
			setCouponAmount(couponAmount);
			setRealAmount(realAmountResidue);
			return BigDecimal.ZERO;
		}
	}

	public BigDecimal getTotalAmount() {
		return realAmount.add(couponAmount);
	}
}
