package com.xxfc.platform.order.contant.enumerate;

import java.util.HashMap;
import java.util.Map;

public enum ItemTypeEnum {
    //item 类型 101--租车车型 102--车损免赔 103--司机费用 201--旅游成人 202--旅游儿童 203--旅游保险 301--会员
    VEHICLE_MODEL(101, "租车车型"),
    DAMAGE_SAFE(102, "车损免赔"),
    DRIVER(103, "司机"),
    TOUR_ADULT(201, "旅游成人"),
    TOUR_CHILD(202, "旅游儿童"),
    TOUR_INSURE(203, "旅游保险"),
    MEMBER(301, "会员"),
    ;
    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    public static Map<Integer, ItemTypeEnum> codeAndDesc = new HashMap<Integer, ItemTypeEnum>();
            //Maps.newHashMap();

    static{
        for(ItemTypeEnum enumE : ItemTypeEnum.values()){
            codeAndDesc.put(enumE.getCode(), enumE);
        }
    }

    ItemTypeEnum(Integer code, String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

    public static ItemTypeEnum get(Integer code) {
        for(ItemTypeEnum enumE : ItemTypeEnum.values()) {
            if (enumE.getCode().equals(code)) {
                return enumE;
            }
        }
        return null;
    }
}