package com.xxfc.platform.order.biz.rpc;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.mapper.BaseOrderMapper;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@Service
public class OrderListBiz extends BaseBiz<BaseOrderMapper, BaseOrder> {

    /**
     *
     * @param dateTime 筛选的时间
     * @param type 筛选的类型， 1，租车，2，旅游
     * @return
     */
    public ObjectRestResponse<List<OrderPageVO>> getOrderList(Long dateTime, Integer type, Integer status) {
           Map<String, Object> map = new HashMap<>();
            if (dateTime != null) {
                map.put("startTime", getDayStart(dateTime));
                map.put("endTime", getDayStart(dateTime) + 3600 * 24 * 1000);
            }
            map.put("status", status);
            if (type == OrderTypeEnum.RENT_VEHICLE.getCode()) { //租车
                List<OrderPageVO> list = mapper.selectAllRentVehicleOrder(map);
                return ObjectRestResponse.succ(list);
            } else if (type == OrderTypeEnum.TOUR.getCode()) {
                List<OrderPageVO> list = mapper.selectAllTourOrder(map);
                return ObjectRestResponse.succ(list);
            } else {
                return ObjectRestResponse.succ();
            }

        }

    public static Long getDayStart(Long datetime) {
        long current = datetime;
        long zero = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
        return zero;
    }

}
