package com.xxfc.platform.vehicle.biz;


import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleManageApply;
import com.xxfc.platform.vehicle.mapper.VehicleManageApplyMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@Service
public class VehicleManageApplyBiz extends BaseBiz<VehicleManageApplyMapper, VehicleManageApply> {


    @Autowired
    VehicleBiz vehicleBiz;




    public List<VehicleManageApply>  getManageApply(VehicleManageApply vehicleManageApply){
        Example example=new Example(VehicleManageApply.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel",0);
        if (vehicleManageApply.getType() != null){
            criteria.andEqualTo("type",vehicleManageApply.getType());
        }
        if (StringUtils.isNotBlank(vehicleManageApply.getVehicleId())){
            criteria.andEqualTo("vehicleId",vehicleManageApply.getVehicleId());
        }
        if (vehicleManageApply.getToApplyId() != null && vehicleManageApply.getToApplyId() > 0){
            criteria.andEqualTo("toApplyId",vehicleManageApply.getToApplyId());
        }
        if (vehicleManageApply.getStatus()   != null){
            criteria.andEqualTo("status",vehicleManageApply.getStatus());
        }

        return  selectByExample(example);
    }


    public  VehicleManageApply getApplyByOrder(String vehicleId){
        return mapper.getVehicleApply(vehicleId);
    }


    public  void  applyManage(VehicleManageApply vehicleManageApply){
        vehicleManageApply.setStatus(0);
        List<VehicleManageApply> manageApply = getManageApply(vehicleManageApply);
        if (manageApply.size() > 0){
            throw  new BaseException("已存在未审核的记录",ResultCode.FAILED_CODE);
        }
        Vehicle vehicle = vehicleBiz.selectById(vehicleManageApply.getVehicleId());
        if (vehicle == null ){
            throw  new BaseException("车辆信息不存在",ResultCode.FAILED_CODE);
        }
        vehicleManageApply.setToApplyId(vehicle.getSubordinateBranch());
        if (vehicleManageApply.getApplyId().equals(vehicleManageApply.getToApplyId())){
            throw  new BaseException("无申请权限",ResultCode.FAILED_CODE);
        }
        Integer type = vehicleManageApply.getType() == null ? 1 : vehicleManageApply.getType();
        if (type == 2){
            vehicleManageApply.setStatus(1);
            insertSelective(vehicleManageApply);
            vehicleManageApply.setId(null);
            vehicleManageApply.setType(3);
            vehicleManageApply.setStatus(0);
            insertSelective(vehicleManageApply);
            vehicleBiz.setState(vehicleManageApply.getVehicleId(),2);
        }else {
            insertSelective(vehicleManageApply);
        }
    }

    public  void  setVerify(VehicleManageApply vehicleManageApply){
        Vehicle vehicle = vehicleBiz.selectById(vehicleManageApply.getVehicleId());
        if (vehicle == null ){
            throw  new BaseException("车辆信息不存在",ResultCode.FAILED_CODE);
        }
        Integer status=vehicleManageApply.getStatus() == null ? 1: vehicleManageApply.getStatus();
        vehicleManageApply.setStatus(0);
        List<VehicleManageApply> manageApply = getManageApply(vehicleManageApply);
        if (manageApply.size() ==  0){
            throw  new BaseException("不存在未审核的记录",ResultCode.FAILED_CODE);
        }
        VehicleManageApply vehicleManageApply1 = manageApply.get(0);
        vehicleManageApply.setId(vehicleManageApply1.getId());
        vehicleManageApply.setStatus(status);
        updateSelectiveById(vehicleManageApply);
        if (status == 1){
            Integer type = vehicleManageApply1.getType();
            Integer applyId = vehicleManageApply1.getApplyId();
            Integer toApplyId = vehicleManageApply1.getToApplyId();
            if (type == 1){
                vehicle.setManageCompanyId(applyId);
            }else if (type == 3){
                vehicle.setManageCompanyId(toApplyId);
                vehicle.setParkBranchCompanyId(toApplyId);
            }
            vehicleBiz.updateSelectiveById(vehicle);
        }


    }


}
