package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.BaseCommissionRatioBiz;;
import com.github.wxiaoqi.security.admin.entity.BaseCommissionRatio;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/commissionRatio")
@Api(tags = {"拥金比例"})
public class AdminBaseCommissionRatioController extends BaseController<BaseCommissionRatioBiz, BaseCommissionRatio> implements UserRestInterface {


    @Autowired
    UserFeign userFeign;


    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }


    @GetMapping("selectList")
    @ApiModelProperty("列表")
    public  ObjectRestResponse selectList(BaseCommissionRatio baseCommissionRatio) {
     return ObjectRestResponse.succ( baseBiz.selectListAll());
    }


    @PostMapping("setting")
    @ApiModelProperty("设置")
    public  ObjectRestResponse setting(@RequestBody List<BaseCommissionRatio> commissionRatios) {
        for (BaseCommissionRatio commissionRatio:commissionRatios) {
            baseBiz.updateSelectiveById(commissionRatio);
        }
        return ObjectRestResponse.succ();
    }



}
