package com.github.wxiaoqi.security.common.config.global;

import com.github.wxiaoqi.security.common.handler.GlobalExceptionHandler;
import com.github.wxiaoqi.security.common.handler.PlatformExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;


public class GlobalBasicConfiguration implements ApplicationRunner{

	private static Logger log = LoggerFactory.getLogger(GlobalBasicConfiguration.class);
	private static Environment env;

	@Bean
	@ConditionalOnMissingBean
	private GlobalExceptionHandler addGlobalExceptionHandler() {
		return new GlobalExceptionHandler();
	}
	@Bean
	@ConditionalOnMissingBean
	private PlatformExceptionHandler addPlatformExceptionHandler() {
		return new PlatformExceptionHandler();
	}

	@Autowired
	private void setEnv(Environment env) {
		GlobalBasicConfiguration.env = env;
	}

	@Override
	public void run(ApplicationArguments args) throws Exception {
		showApplicationProperties("数据库连接地址: ", "spring.datasource.url");
		showApplicationProperties("Redis连接主机: ", "spring.redis.host");
		showApplicationProperties("Redis连接端口: ", "spring.redis.port");
		showApplicationProperties("rabbitmq连接主机", "spring.rabbitmq.host");
		showApplicationProperties("rabbitmq连接虚拟机", "spring.rabbitmq.virtual-host");
	}

	public static void showApplicationProperties(String key, String value) {
		if(env != null) {
			log.info(key + "{}", env.getProperty(value));
		}
	}
}
