package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleRecordEmployBiz;
import com.xxfc.platform.vehicle.pojo.dto.VehicleRecordEmployDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("app/vehicleRecord")
@Api(tags = {"车辆预定占用"})
public class AppVehicleRecordEmployController extends BaseController<VehicleRecordEmployBiz> {







    @PostMapping("addOrUpd")
    @ApiModelProperty("更新")
    public  ObjectRestResponse updVehicle(@RequestBody VehicleRecordEmployDTO vehicleRecordEmployDTO) throws Exception{
        if (vehicleRecordEmployDTO.getCompanyId() == null || vehicleRecordEmployDTO.getCompanyId() == 0){
            List<Integer> companyIds = getBusinessUserCompanyIds();
            if (companyIds != null && companyIds.size() > 0){
                vehicleRecordEmployDTO.setCompanyId(companyIds.get(0));
            }
        }
        baseBiz.addOrUpd(vehicleRecordEmployDTO);
        return ObjectRestResponse.succ();
    }


    @GetMapping("info/{vehicelId}")
    @ApiModelProperty("详情")
    public  ObjectRestResponse info(@PathVariable(value = "vehicelId") String vehicelId) {
        return  ObjectRestResponse.succ(baseBiz.getInfo(vehicelId));
    }














}
