package com.xxfc.platform.vehicle.biz;



import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.tour.dto.TourUserScoreListDTO;
import com.xxfc.platform.vehicle.entity.VehiclePublishGoods;
import com.xxfc.platform.vehicle.mapper.VehiclePublishGoodsMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishFindDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePublishReceiveDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleExtensionVO;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishGoodsVo;
import com.xxfc.platform.vehicle.pojo.vo.VehiclePublishReceiveVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service
@Slf4j
public class VehiclePublishGoodsBiz extends BaseBiz<VehiclePublishGoodsMapper, VehiclePublishGoods> {


    @Autowired
    VehicleExtensionBiz extensionBiz;

    @Autowired
    VehiclePublishReceiveBiz publishReceiveBiz;

    @Autowired
    UserFeign userFeign;




    public List<VehiclePublishGoodsVo> getList(VehiclePublishFindDTO publishFindDTO){
        List<VehiclePublishGoodsVo> list = mapper.selectList(publishFindDTO);
        setGoodsList(list,publishFindDTO);
        return list;
    }



    public List<VehiclePublishGoodsVo> getListByOrderNo(VehiclePublishFindDTO publishFindDTO){
        List<VehiclePublishGoodsVo> list = mapper.selectListByOrderNo(publishFindDTO);
        setGoodsList(list,publishFindDTO);
        return list;
    }

    public  void  setGoodsList(List<VehiclePublishGoodsVo> list,VehiclePublishFindDTO publishFindDTO){
        Integer receivetype = publishFindDTO.getReceivetype() == null ? 0 : publishFindDTO.getReceivetype();
        if (CollectionUtils.isNotEmpty(list)){
            for (VehiclePublishGoodsVo publishGoodsVo : list){
                String vehicleId = publishGoodsVo.getVehicleId();
                List<VehicleExtensionVO> extensionVOS = new ArrayList<>();
                if (StringUtils.isNotBlank(vehicleId)){
                    extensionVOS=extensionBiz.getTree(vehicleId);
                }else {
                    String extensionList = publishGoodsVo.getExtensionList();
                    if (StringUtils.isNotBlank(extensionList)){
                        extensionVOS=extensionBiz.getTreeByApply(Arrays.asList(extensionList.split(",")).parallelStream().map(s -> Integer.valueOf(s)).collect(Collectors.toList()));
                    }
                }
                publishGoodsVo.setExtensionVOS(extensionVOS);
                if (receivetype > 0)
                    setReceive(publishGoodsVo,publishFindDTO);
            }
        }
    }

    public  void  setReceive(VehiclePublishGoodsVo publishGoodsVo,VehiclePublishFindDTO publishFindDTO){
        publishFindDTO.setPublishGoodsId(publishGoodsVo.getId());
        List<VehiclePublishReceiveVo> list = publishReceiveBiz.getListByUserId(publishFindDTO);
        if (CollectionUtils.isNotEmpty(list)){
            List<Integer> userIds = list.stream().map(VehiclePublishReceiveVo::getReceiveUserId).distinct().collect(Collectors.toList());
            List<AppUserVo> appUserVos = userFeign.getByUserIds(userIds).getData();
            if (log.isDebugEnabled()){
                log.debug("根据用户ids查询出用户信息：【{}】",appUserVos);
            }
            Map<Integer, AppUserVo> userMap = appUserVos.stream().collect(Collectors.toMap(AppUserVo::getUserid, Function.identity()));
            for (VehiclePublishReceiveVo receiveVo : list){
                AppUserVo appUserVo = userMap.get(receiveVo.getReceiveUserId());
                if (appUserVo != null ){
                    receiveVo.setUserName(appUserVo.getUsername());
                }
                String statusStr = receiveVo.getStatusStr();
                if (StringUtils.isNotBlank(statusStr)){
                    List<Integer> statusIds = Arrays.asList(statusStr.split(",")).parallelStream().map(s -> Integer.valueOf(s)).collect(Collectors.toList());
                    Long count = statusIds.stream().filter(x->x == 1).count();
                    count = count == null ? 0L :count;
                    receiveVo.setWaitNumber(count);
                    Integer buttonState = 0;
                    if (count > 0){
                        buttonState = 1;
                    }else {
                        if (statusStr.contains("3")){
                            buttonState =2;
                        }else if (statusStr.contains("5"))
                            buttonState = 3;
                    }
                    receiveVo.setButtonState(buttonState);
                }
                String ids = receiveVo.getIds();
                if (StringUtils.isNotBlank(ids)){
                    List<Integer> idList = Arrays.asList(ids.split(",")).parallelStream().map(s -> Integer.valueOf(s)).collect(Collectors.toList());
                    VehiclePublishReceiveDTO receiveDTO = new VehiclePublishReceiveDTO();
                    receiveDTO.setIds(idList);
                    receiveVo.setPublishReceiveVos( publishReceiveBiz.getListByIds(receiveDTO));
                }

            }
            publishGoodsVo.setReceiveVos(list);
        }

    }


    public List<VehiclePublishGoods> getListByPublishId(Integer publishId){
        return  mapper.groupGoodsIdList(publishId);
    }

    public  void  updReceiveNumber(Integer publishId){
        List<VehiclePublishGoods> list = getListByPublishId(publishId);
        if (CollectionUtils.isNotEmpty(list)){
            for (VehiclePublishGoods publishGoods : list){
                updateSelectiveById(publishGoods);
            }
        }
    }

    public VehiclePublishGoods getGoods(String vehicleId){
        return  mapper.getGoodsByVehicleId(vehicleId);
    }









}
