package com.xxfc.platform.uccn.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.uccn.biz.NewsTypeBiz;
import com.xxfc.platform.uccn.dto.NewsTypeDto;
import com.xxfc.platform.uccn.entity.NewsType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("newsType")
public class NewsTypeController extends BaseController<NewsTypeBiz, NewsType> {

	@PostMapping(value = "addUpdate")
	public ObjectRestResponse addOrUpdate(@RequestBody NewsType newsType) {
		return baseBiz.add(newsType);
	}

	@GetMapping(value = "/app/unauth/getAll")
	public ObjectRestResponse getAll() {
		return baseBiz.getAll();
	}

	@GetMapping(value = "getList")
	public ObjectRestResponse getList(NewsTypeDto newsTypeDto) {
		return baseBiz.selectList(newsTypeDto);
	}

}