package com.xxfc.platform.order.entity;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@Data
@Table(name = "branch_company")
public class BranchCompany {
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;

    @Column(name = "company_base_id")
    @ApiModelProperty("主键id")
    private Integer companyBaseId;


    @Column(name = "company_id")
    @ApiModelProperty("公司id")
    private Long companyId;

    /**
     * 分公司名称
     */
    @ApiModelProperty("分公司名称")
    private String name;


    @ApiModelProperty("门头照")
    @Column(name = "head_logo")
    private String headLogo;


    @Column(name = "short_name")
    @ApiModelProperty("简称")
    private String shortName;


    @Column(name = "business_scope")
    @ApiModelProperty("经营范围(逗号隔开)")
    private String businessScope;
    /**
     * 分支机构类型
     */
    @Column(name = "branch_type")
    @ApiModelProperty("分支机构类型")
    private Integer branchType;

    /**
     * 分支机构所属机构
     */
    @Column(name = "subordinate_branch")
    @ApiModelProperty("分支机构所属机构")
    private Integer subordinateBranch;



    /**
     * 地址-省/直辖市(编码)
     */
    @Column(name = "addr_province")
    @ApiModelProperty("地址-省/直辖市(编码)")
    private Integer addrProvince;

    /**
     * 地址-省/直辖市(编码)名称
     */
    @Column(name = "province_name")
    @ApiModelProperty("地址-省/直辖市(编码)名称")
    private String provinceName;

    /**
     * 地址-市(编码)
     */
    @Column(name = "addr_city")
    @ApiModelProperty("地址-市(编码)")
    private Integer addrCity;


    /**
     * 地址-市(编码)名称
     */
    @Column(name = "city_name")
    @ApiModelProperty("地址-市(编码名称")
    private String cityName;

    /**
     * 地址-镇/县（编码）
     */
    @Column(name = "addr_town")
    @ApiModelProperty("地址-镇/县（编码）")
    private Integer addrTown;

    /**
     * 地址-县名称
     */
    @Column(name = "town_name")
    @ApiModelProperty("县名称")
    private String townName;

    /**
     * 详细地址
     */
    @Column(name = "addr_detail")
    @ApiModelProperty("详细地址")
    private String addrDetail;

    private Date createTime;

    private Date updateTime;

    /**
     * 负责人
     */
    @ApiModelProperty("负责人")
    private String leader;

    /**
     * 负责人联系方式
     */
    @ApiModelProperty("负责人联系方式")
    private String leaderContactInfo;


    @ApiModelProperty("邀请码")
    private String code;


    @ApiModelProperty("邀请人id")
    @Column(name = "inviter_account")
    private Integer inviterAccount;



    /**
     * 分公司状态
     */
    @ApiModelProperty("分公司状态")
    private Integer status;

    /**
     *公司地址-纬度
     */
    @ApiModelProperty("公司地址-纬度")
    private BigDecimal latitude;

    /**
     * 公司地址-经度
     */
    @ApiModelProperty("公司地址-经度")
    private BigDecimal longitude;

    private String companyPic;

    private Integer zoneId;

    private String phone;

    /**
     * 租车客服电话
     */
    @Column(name = "vehice_service_phone")
    @ApiModelProperty("租车客服电话")
    private String vehiceServicePhone;
    /**
     * 旅游客服电话
     */
    @Column(name = "tour_service_phone")
    @ApiModelProperty("旅游客服电话")
    private String tourServicePhone;

    /**
     * 上下架:1-上架；2-下架
     */
    private Integer state;
    /**
     * 是否app展示：1-是；2-否
     */
    @Column(name = "is_show")
    private Integer isShow;

    /**
     * 是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
    private Integer isDel;

    //浏览量
    @Column(name = "browse_num")
    private Integer browseNum;

    //点赞数量
    @Column(name = "give_num")
    private Integer giveNum;


}