package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.ActivityProductBiz;
import com.xxfc.platform.activity.entity.ActivityProduct;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/activity/product")
public class ActivityProductController extends BaseController<ActivityProductBiz, ActivityProduct> {

	@GetMapping(value = "/app/unauth/getAll")
	public ObjectRestResponse getAll() {
		return ObjectRestResponse.succ(baseBiz.getAll());
	}

	@GetMapping(value = "/app/unauth/get")
	public ObjectRestResponse<ActivityProduct> getOne(Long id) {
		return ObjectRestResponse.succ(baseBiz.getOne(id));
	}

	@PostMapping(value = "/app/unauth/add")
	public ObjectRestResponse add(@RequestBody ActivityProduct activityProduct) {
		return baseBiz.add(activityProduct);
	}

	@PostMapping(value = "/app/unauth/update")
	public ObjectRestResponse updateProduct(@RequestBody ActivityProduct activityProduct) {
		return baseBiz.update(activityProduct);
	}
}
