package com.xxfc.platform.activity.vo;

import com.xxfc.platform.activity.entity.Coupon;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/23 10:55
 */
@Data
public class CouponPagVo extends Coupon {


    @ApiModelProperty("主键id")
    private Integer id;


    @ApiModelProperty(value = "优惠券标题（有图片则显示图片）：无门槛50元优惠券 | 单品最高减2000元")
    private String title;

    @ApiModelProperty(value = "图片")
    private String icon;

    @ApiModelProperty(value = "0-全平台；1-租车；2-旅游；3-营地；4--会员; 5-机车；6-游艇")
    private Integer channel;

    @ApiModelProperty(value = "1满减券 2叠加满减券 3无门槛券（需要限制大小）")
    private Integer type;

    @ApiModelProperty(value = "用券抵扣金额")
    private BigDecimal usedAmount;


    @ApiModelProperty(value = "配额：发券数量")
    private Integer quota;


    @ApiModelProperty(value = "已领取的优惠券数量")
    private Integer takeCount;


    @ApiModelProperty(value = "已使用的优惠券数量")
    private Integer usedCount;


    @ApiModelProperty(value = "1生效 2失效 3已结束")
    private Integer status;


    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;

    /**
     *  发放开始时间
     */
    @Column(name = "start_time")
    @ApiModelProperty(value = "发放开始时间")
    private Long startTime;

    /**
     *  发放结束时间
     */
    @Column(name = "end_time")
    @ApiModelProperty(value = "发放结束时间")
    private Long endTime;

}
