package com.github.wxiaoqi.security.admin.rest;


import com.github.wxiaoqi.security.admin.biz.AppUserAlipayBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("/alipay")
public class AppUserAliPayController {
    @Autowired
    AppUserAlipayBiz appUserAlipayBiz;

    @GetMapping("/getUserInfo")
    public ObjectRestResponse getUserInfo(String code, HttpServletRequest request) {
        return appUserAlipayBiz.getUserInfo(code, request);
    }


    @GetMapping("/get")
    public ObjectRestResponse get(HttpServletRequest request) {
        return ObjectRestResponse.succ(appUserAlipayBiz.getByUserId(request));
    }
}
