package com.github.wxiaoqi.security.admin.mapper;



import com.github.wxiaoqi.security.admin.dto.WalletCathDTO;
import com.github.wxiaoqi.security.admin.dto.WalletCathSumDto;
import com.github.wxiaoqi.security.admin.entity.CompanyWalletCath;
import com.github.wxiaoqi.security.admin.vo.CompanyWalletCathVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;


/**
 * 钱包提现表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
public interface CompanyWalletCathMapper extends Mapper<CompanyWalletCath> {

    List<CompanyWalletCathVo> selectList(WalletCathDTO walletCathDTO);

    @Select("SELECT IFNULL(SUM(amount),0) FROM company_wallet_cath WHERE company_id =#{companyId} AND stauts=0")
    BigDecimal sunAmountByStatus(@Param("companyId") Integer companyId);


    /**
     * 计算提现的金额
     * @param type 1-日；2-月
     * @return
     */
    WalletCathSumDto sumCathAmount(@Param("companyId") Integer companyId, @Param("type") int type);

}
