package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 评价标签
 * 
 * @author wuweizhi
 * @email 18178966185@163.com
 * @date 2020-11-16 14:07:35
 */
@Data
@Table(name = "appraise_label_info")
public class AppraiseLabelInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("")
    private Integer id;
	
	    /**
     *  标签名称
     */
    @Column(name = "name")
	@ApiModelProperty(value = "标签名称")
    private String name;
	
	    /**
     *  分值
     */
    @Column(name = "point")
	@ApiModelProperty(value = "分值")
    private Integer point;
	
	    /**
     *  0-全部，1-房车，2-机车，3-游艇，4豪车
     */
    @Column(name = "type")
	@ApiModelProperty(value = "0-全部，1-房车，2-机车，3-游艇，4豪车")
    private Integer type;
	
	    /**
     *  是否启用：0、否，1、是
     */
    @Column(name = "enable")
	@ApiModelProperty(value = "是否启用：0、否，1、是")
    private Integer enable;
	
	    /**
     *  是否删除：0、否，1、是
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0、否，1、是")
    private Integer isDel;
	
	    /**
     *  
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "", hidden = true )
    private Long crtTime;
	
	    /**
     *  
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "", hidden = true )
    private Long updTime;
	
	    /**
     *  规则:[{"star":1,"point":20,"level":"一般"}]
     */
    @Column(name = "rules")
	@ApiModelProperty(value = "规则:[{\"star\":1,\"point\":20,\"level\":\"一般\"}]")
    private String rules;
	
	    /**
     *  排序
     */
    @Column(name = "sort")
	@ApiModelProperty(value = "排序")
    private Integer sort;
	
	@Column(name = "tag_type")
	private Integer tagType;
}
