package com.github.wxiaoqi.security.admin.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 拥金明细
 */
@Data
public class OrderWaterDTO {




    /**
     *  用户id
     */
    @ApiModelProperty(value = "用户id")
    private Integer userId;

    /**
     *  订单id
     */
    @ApiModelProperty(value = "订单id")
    private Integer orderId;

    /**
     *  订单号
     */
    @ApiModelProperty(value = "订单号")
    private String orderNo;


    /**
     * 1.已支付,2-已完成,3-已退款
     */
    @ApiModelProperty(value = "订单状态")
    private Integer status;


    @ApiModelProperty(value = "店铺id")
    private Integer companyId;


    @ApiModelProperty(value = "分账id(不用传)")
    private Integer acceptId;


    @ApiModelProperty(value = "正分账id(不用传)")
    private Integer zAcceptId;

    @ApiModelProperty(value = "分账金额")
    private BigDecimal orderAmount;


    @ApiModelProperty(value = "订单商品")
    private List<OrderGoodsDTO> goodsDTOList;



}