/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.protocol;

import java.io.IOException;
import ytx.org.apache.http.Header;
import ytx.org.apache.http.HttpEntity;
import ytx.org.apache.http.HttpException;
import ytx.org.apache.http.HttpRequest;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.HttpResponseInterceptor;
import ytx.org.apache.http.HttpVersion;
import ytx.org.apache.http.ProtocolVersion;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class ResponseConnControl
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpRequest request;
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response.setHeader("Connection", "Close");
            return;
        }
        Header explicit = response.getFirstHeader("Connection");
        if (explicit != null && "Close".equalsIgnoreCase(explicit.getValue())) {
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
            if (entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
                response.setHeader("Connection", "Close");
                return;
            }
        }
        if ((request = (HttpRequest)context.getAttribute("http.request")) != null) {
            Header header = request.getFirstHeader("Connection");
            if (header != null) {
                response.setHeader("Connection", header.getValue());
            } else if (request.getProtocolVersion().lessEquals(HttpVersion.HTTP_1_0)) {
                response.setHeader("Connection", "Close");
            }
        }
    }
}

