package com.xxfc.platform.order.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.Query;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.google.common.collect.Lists;
import com.xxfc.platform.activity.feign.ActivityFeign;
import com.xxfc.platform.order.biz.inner.OrderMsgBiz;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.*;
import com.xxfc.platform.order.mapper.BaseOrderMapper;
import com.xxfc.platform.order.pojo.mq.OrderMQDTO;
import com.xxfc.platform.order.pojo.order.OrderListVo;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.order.pojo.order.OrderVehicleCrosstownDto;
import com.xxfc.platform.order.pojo.order.QueryOrderDTO;
import com.xxfc.platform.order.rest.BaseOrderController;
import com.xxfc.platform.tour.feign.TourFeign;
import com.xxfc.platform.universal.constant.DictionaryKey;
import com.xxfc.platform.universal.dto.SendMsgDTO;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.MQSenderFeign;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.CompanyDetail;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;
import static com.xxfc.platform.universal.constant.DictionaryKey.APP_ORDER;

/**
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-15 21:30:33
 */
@Service
@Slf4j
public class BaseOrderBiz extends BaseBiz<BaseOrderMapper, BaseOrder> {

    @Autowired
    OrderMemberDetailBiz orderMemberDetailBiz;

    @Autowired
    OrderTourDetailBiz orderTourDetailBiz;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderVehicleCrosstownBiz orderVehicleCrosstownBiz;

    @Autowired
    OrderUserLicenseBiz orderUserLicenseBiz;

    @Autowired
    OrderRefundBiz orderRefundBiz;

    @Autowired
    OrderItemBiz orderItemBiz;

    @Autowired
    VehicleFeign vehicleFeign;

    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    TourFeign tourFeign;

    @Autowired
    UserFeign userFeign;

    @Autowired
    MQSenderFeign mqSenderFeign;

    @Autowired
    OrderMsgBiz orderMsgBiz;

    @Autowired
    ActivityFeign activityFeign;

    public List<OrderPageVO> pageByParm(Map<String, Object> paramMap) {
        return mapper.pageByParm(paramMap);
    }

    public List<OrderListVo> listOrder(Map<String, Object> paramMap) {

        return mapper.listOrder(paramMap);
    }

    public List<OrderPageVO> getRentVehicle(Map<String, Object> paramMap) {
        return mapper.getRentVehicle(paramMap);
    }

    public List<OrderPageVO> getTourList(Map<String, Object> paramMap) {
        return mapper.getTourList(paramMap);
    }

    /**
     * 获取订单详情
     *
     * @param no
     * @return
     */
    public ObjectRestResponse<OrderPageVO> getOrderDetail(String no, UserDTO userDTO) {
        OrderPageVO orderPageVo = mapper.getOrderDetail(no);
        if (orderPageVo == null) {
            return ObjectRestResponse.createFailedResult(ResCode.ORDER_IS_NOT_EXIST.getCode(), ResCode.ORDER_IS_NOT_EXIST.getDesc());
        }
        if(orderPageVo.getStatus() <= 3 && orderPageVo.getStatus() != 2 && orderPageVo.getStatus() != -1) {
            return ObjectRestResponse.createFailedResult(ResCode.ORDER_DETAIL_IS_NOT_EXIST.getCode(), ResCode.ORDER_DETAIL_IS_NOT_EXIST.getDesc());
        }
        AppUserDTO appUserVo = userFeign.userDetailById(orderPageVo.getUserId()).getData();
        if(appUserVo != null) {
            orderPageVo.setTelephone(appUserVo.getUsername());
            orderPageVo.setUsername(appUserVo.getNickname());
        }
        List<BranchCompany> branchCompanies = vehicleFeign.companyAll(userDTO.getDataAll(), userDTO.getDataCompany(), userDTO.getDataZone());
        List<Integer> companyIds = branchCompanies.stream().map(BranchCompany::getId).collect(Collectors.toList());

        if (orderPageVo.getOrderRentVehicleDetail() != null) {
            if (!companyIds.contains(orderPageVo.getOrderRentVehicleDetail().getStartCompanyId()) && !companyIds.contains(orderPageVo.getOrderRentVehicleDetail().getEndCompanyId())) {
                return ObjectRestResponse.createFailedResult(ResCode.YOU_AUTH_FAIL.getCode(), ResCode.YOU_AUTH_FAIL.getDesc());
            }
            if(userDTO.getCompanyId() == orderPageVo.getOrderRentVehicleDetail().getEndCompanyId()) {
                orderPageVo.setUserCompanyStatus(true);
            }
            if (orderPageVo.getStatus() == 4) { //未交车
//                boolean flag = getTodayTime(orderPageVo.getOrderRentVehicleDetail().getStartTime());
//                if (!flag) {
//                    return ObjectRestResponse.createFailedResult(3501, "今日不是交车日期");
//                }
                getDriverInfo(orderPageVo);
            } else if (orderPageVo.getStatus() >= 5 || orderPageVo.getStatus() == -1) {//出行中 已交车
                getDriverInfo(orderPageVo);
                getUserLicense(orderPageVo);
            }
            ObjectRestResponse<CompanyDetail> startResponse = vehicleFeign.getCompanyDetail(orderPageVo.getOrderRentVehicleDetail().getStartCompanyId());
            if (startResponse.getData() != null) {
                orderPageVo.setStartCompanyName(startResponse.getData().getName());
            }

            ObjectRestResponse<CompanyDetail> restResponse = vehicleFeign.getCompanyDetail(orderPageVo.getOrderRentVehicleDetail().getEndCompanyId());
            if (restResponse.getData() != null) {
                orderPageVo.setEndCompanyName(restResponse.getData().getName());
            }
            RestResponse<Vehicle> response = vehicleFeign.findById(orderPageVo.getOrderRentVehicleDetail().getVehicleId());
            if (response.getData() != null) {
                orderPageVo.setVehicalNumberPlat(response.getData().getNumberPlate());
            }
        } else if (orderPageVo.getOrderTourDetail() != null) {
            List<Integer> ids = Lists.newArrayList();
            if (orderPageVo.getOrderTourDetail().getTourUserIds().contains(",")) {
                String[] strings = orderPageVo.getOrderTourDetail().getTourUserIds().split(",");
                for (int i = 0; i < strings.length; i++) {
                    ids.add(Integer.parseInt(StringUtils.isNotBlank(strings[i]) ? strings[i] : "0"));
                }
            } else {
                ids.add(Integer.parseInt(orderPageVo.getOrderTourDetail().getTourUserIds()));
            }
            List<AppUserVo> list = userFeign.getByUserIds(ids).getData();
            orderPageVo.getOrderTourDetail().setUserVoList(list == null || list.size() <= 0 ? new ArrayList<>() : list);
        }
        //设置保留金
        Map<String, Dictionary> dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
        BigDecimal illegalReserve = new BigDecimal(dictionaryMap.get(APP_ORDER + "_" + DictionaryKey.ILLEGAL_RESERVE).getDetail());
        orderPageVo.setIllegalReserve(illegalReserve);
        orderPageVo.setItems(orderItemBiz.selectList(new OrderItem(){{
            setOrderId(orderPageVo.getId());
        }}));
        return ObjectRestResponse.succ(orderPageVo);
    }

    public void getUserLicense(OrderPageVO orderPageVo) {
        OrderVehicleCrosstownDto orderVehicleCrosstownDto = new OrderVehicleCrosstownDto();
        orderVehicleCrosstownDto.setOrderId(orderPageVo.getId());
        orderVehicleCrosstownDto.setOrderNo(orderPageVo.getNo());
        List<OrderVehicleCrosstownDto> orderVehicleCrosstowns = orderVehicleCrosstownBiz.selectByOrderId(orderVehicleCrosstownDto);
        if (orderVehicleCrosstowns != null && orderVehicleCrosstowns.size() > 0) {
            List<OrderUserLicense> orderUserLicenses = orderUserLicenseBiz.selectByIds(orderVehicleCrosstowns.get(0).getUserLicenseId()).getData();
            if (orderUserLicenses != null && orderUserLicenses.size() > 0) {
                orderVehicleCrosstownDto.setLicenseIdCard(orderUserLicenses.get(0).getLicenseIdCard());
                orderVehicleCrosstownDto.setLicenseImg(orderUserLicenses.get(0).getLicenseImg());
                orderVehicleCrosstownDto.setLicenseName(orderUserLicenses.get(0).getLicenseName());
                orderVehicleCrosstownDto.setLicensePhone(orderUserLicenses.get(0).getLicensePhone());
            }

        }
        orderPageVo.setOrderVehicleCrosstownDto(orderVehicleCrosstownDto);
    }

    public void  getDriverInfo(OrderPageVO orderPageVo) {
        List<VehicleUserLicense> vehicleUserLicenses = Lists.newArrayList();
        String myDriverIds = orderPageVo.getOrderRentVehicleDetail().getMyDriverIds();
        if (StringUtils.isNotBlank(myDriverIds)) {
            if (myDriverIds.contains(",")) {
                String[] ids = myDriverIds.split(",");
                try {
                    //目前暂定一个驾驶人，后期需要更改再此更改
                    RestResponse<VehicleUserLicense> restResponse = vehicleFeign.getOne(Integer.parseInt(ids[0]));
                    log.info(restResponse.getMessage());
                    if (restResponse.getData() != null) {
                        vehicleUserLicenses.add(restResponse.getData());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    vehicleUserLicenses.add(vehicleFeign.getOne(Integer.parseInt(myDriverIds.trim())).getData());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        orderPageVo.setVehicleUserLicenses(vehicleUserLicenses);
    }


    public ObjectRestResponse<OrderPageVO> getOrderDetail(String no) {
        OrderPageVO orderPageVo = mapper.getOrderDetail(no);
        if (orderPageVo == null) {
            return ObjectRestResponse.createFailedResult(ResCode.ORDER_IS_NOT_EXIST.getCode(), ResCode.ORDER_IS_NOT_EXIST.getDesc());
        }
        if (orderPageVo.getOrderRentVehicleDetail() != null) {
            if (orderPageVo.getStatus() == 4) { //未交车
//                boolean flag = getTodayTime(orderPageVo.getOrderRentVehicleDetail().getStartTime());
//                if (!flag) {
//                    return ObjectRestResponse.createFailedResult(3501, "今日不是交车日期");
//                }
                getDriverInfo(orderPageVo);
            } else if (orderPageVo.getStatus() >= 5 || orderPageVo.getStatus() == -1) {//出行中 已交车
                getDriverInfo(orderPageVo);
                getUserLicense(orderPageVo);
            }
            RestResponse<Vehicle> restResponse = vehicleFeign.findById(orderPageVo.getOrderRentVehicleDetail().getVehicleId());
            if (restResponse.getData() != null) {
                orderPageVo.setVehicalNumberPlat(restResponse.getData().getNumberPlate());
            }
        } else if (orderPageVo.getOrderTourDetail() != null) {
            List<Integer> ids = Lists.newArrayList();
            if (orderPageVo.getOrderTourDetail().getTourUserIds().contains(",")) {
                String[] strings = orderPageVo.getOrderTourDetail().getTourUserIds().split(",");
                for (int i = 0; i < strings.length; i++) {
                    ids.add(Integer.parseInt(StringUtils.isNotBlank(strings[i]) ? strings[i] : "0"));
                }

            } else {
                ids.add(Integer.parseInt(orderPageVo.getOrderTourDetail().getTourUserIds()));
            }
            List<AppUserVo> list = userFeign.getByUserIds(ids).getData();
            orderPageVo.getOrderTourDetail().setUserVoList(list == null || list.size() <= 0 ? new ArrayList<>() : list);
        }
        //设置保留金
        Map<String, Dictionary> dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
        BigDecimal illegalReserve = new BigDecimal(dictionaryMap.get(APP_ORDER + "_" + DictionaryKey.ILLEGAL_RESERVE).getDetail());
        orderPageVo.setIllegalReserve(illegalReserve);
        orderPageVo.setItems(orderItemBiz.selectList(new OrderItem(){{
            setOrderId(orderPageVo.getId());
        }}));
        return ObjectRestResponse.succ(orderPageVo);
    }

    /**
     * 支付回调处理
     *
     * @param orderNo
     * @param tradeNo
     */
    @Transactional
    public void payNotifyHandle(String orderNo, String tradeNo, Integer type) {
        OrderRentVehicleDetail orvd = new OrderRentVehicleDetail();
        OrderTourDetail otd = new OrderTourDetail();
        OrderMemberDetail omd = new OrderMemberDetail();
        BaseOrder baseOrder = this.selectOne(new BaseOrder() {{
            setNo(orderNo);
        }});

        if (OrderStatusEnum.ORDER_UNPAY.getCode().equals(baseOrder.getStatus()) && baseOrder.getHasPay().equals(SYS_FALSE)) {
            BaseOrder updateOrder = new BaseOrder() {{
                setId(baseOrder.getId());
                setOutTradeNo(tradeNo);
                setHasPay(SYS_TRUE);
                setPayTime(System.currentTimeMillis());
                setPayOrigin(type);
                setVersion(baseOrder.getVersion());
            }};

            //如果是会员订单，则触发会员效益
            if (OrderTypeEnum.MEMBER.getCode().equals(baseOrder.getType())) {
                //直接设置订单完成
                updateOrder.setStatus(OrderStatusEnum.ORDER_FINISH.getCode());
                omd = orderMemberDetailBiz.selectOne(new OrderMemberDetail() {{
                    setOrderId(baseOrder.getId());
                }});

                //触发会员效益
                UserMemberDTO userMemberDTO = new UserMemberDTO() {{
                    setUserId(baseOrder.getUserId());
                    setIsBind(ISBIND_BIND);
                }};
                userMemberDTO.setMemberLevel(omd.getMemberLevel());
                userMemberDTO.setRentFreeDays(omd.getRentFreeNum());
                userMemberDTO.setTotalNumber(omd.getRentFreeNum());
                userMemberDTO.setDiscount(omd.getRebate());

                ObjectRestResponse orr = userFeign.buyMember(userMemberDTO);
                log.info("orr.getStatus() : " + orr.getStatus());
            } else if (OrderTypeEnum.RENT_VEHICLE.getCode().equals(baseOrder.getType())) {
                updateOrder.setStatus(OrderStatusEnum.ORDER_TOSTART.getCode());
                orvd = orderRentVehicleBiz.selectOne(new OrderRentVehicleDetail() {{
                    setOrderId(baseOrder.getId());
                }});
                //车辆预定审核通过
                RestResponse<Integer> result = vehicleFeign.rentProveVehicleBooking(orvd.getBookRecordId());

                //确认免费天数
                if (orvd.getFreeDays() > 0) {
                    userFeign.memberDays(baseOrder.getUserId(), orvd.getFreeDays(), UserFeign.MEMBER_DAYS_CONFIRM);
                }

            } else if (OrderTypeEnum.TOUR.getCode().equals(baseOrder.getType())) {
                updateOrder.setStatus(OrderStatusEnum.ORDER_TOSTART.getCode());
                otd = orderTourDetailBiz.selectOne(new OrderTourDetail() {{
                    setOrderId(baseOrder.getId());
                }});

                //站点总人数添加
                tourFeign.updateTourGoodPersonNum(otd.getVerificationId(), TourFeign.TOTAL_PERSON, otd.getTotalNumber());
            }
            try {
                this.updateSelectiveByIdRe(updateOrder);
            } finally {
                AppUserDTO appUserDTO = userFeign.userDetailById(baseOrder.getUserId()).getData();

                //处理App用户提醒短信的发送
//                orderMsgBiz.handelAppUserMsg(orvd, omd, baseOrder, appUserDTO);
                orderMsgBiz.handelMsgPayNew(orvd, otd, omd, baseOrder, appUserDTO);

                //处理后台用户提醒短信的发送
//                orderMsgBiz.handelBgUserMsg4Pay(orvd, baseOrder, appUserDTO, OrderMsgBiz.RENT_PAY);
                sendOrderMq(orvd, otd, omd, baseOrder, OrderMQDTO.ORDER_PAY);
                if(OrderTypeEnum.MEMBER.getCode().equals(baseOrder.getType())) {
                    sendOrderMq(orvd, otd, omd, baseOrder, OrderMQDTO.ORDER_FINISH);
                }
            }
        } else {
            log.error(" order has payed , orderNo:{}, tradeNo:{} ", orderNo, tradeNo);
        }
    }

    public void sendOrderMq(OrderRentVehicleDetail orvd, OrderTourDetail otd, OrderMemberDetail omd, BaseOrder baseOrder, Integer sign) {
        //发送队列消息
        OrderMQDTO orderMQDTO = BeanUtil.toBean(baseOrder, OrderMQDTO.class);
        orderMQDTO.setOrderRentVehicleDetail(orvd);
        orderMQDTO.setOrderTourDetail(otd);
        orderMQDTO.setOrderMemberDetail(omd);

        //获取item
        orderMQDTO.setItems(orderItemBiz.selectList(new OrderItem() {{
            setOrderId(baseOrder.getId());
        }}));

        sendQueue(orderMQDTO, sign);
    }

    @Override
    public void updateSelectiveById(BaseOrder entity) {
        super.updateSelectiveById(entity);
    }

    /**
     * 更新（不成功抛异常）
     *
     * @param baseOrder
     * @return
     */
    public BaseOrder updateSelectiveByIdReT(BaseOrder baseOrder) {
        return updateSelectiveByIdReT(baseOrder, false);
    }

    /**
     * 更新（不成功抛异常）
     *
     * @param baseOrder
     * @return
     */
    public BaseOrder updateSelectiveByIdReT(BaseOrder baseOrder, boolean needVersion) {
        if (needVersion) {
            baseOrder.setVersion(selectById(baseOrder.getId()).getVersion());
        }
        if (updateSelectiveByIdRe(baseOrder) > 0) {
            return selectById(baseOrder.getId());
        } else {
            throw new BaseException(ResultCode.DB_OPERATION_FAIL_CODE);
        }
    }

//    /**
//     * 更新（不成功抛异常）
//     * @param baseOrder
//     * @return
//     */
//    public BaseOrder updateSelectiveByIdReT(BaseOrder baseOrder) {
//        if(updateSelectiveByIdRe(baseOrder) > 0) {
//            return selectById(baseOrder.getId());
//        }else {
//            throw new BaseException(ResultCode.DB_OPERATION_FAIL_CODE);
//        }
//    }

    public boolean getTodayTime(Long time) {
        Long startTime = getDayStart();
        if (time >= startTime && time <= startTime + 24 * 60 * 60 * 1000 - 1) {
            return true;
        }
        return false;
    }

    public static Long getDayStart() {
        long current = System.currentTimeMillis();
        long zero = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
        return zero;
    }

    private void sendQueue(OrderMQDTO orderMQDTO, Integer sign) {
        try {
            orderMQDTO.setSign(sign);
            SendMsgDTO sendMsgDTO = new SendMsgDTO(){{
                setExchange(ORDER_TOPIC);
            }};
            sendMsgDTO.setJson(JSONUtil.toJsonStr(orderMQDTO));
            switch (sign) {
                case 2:
                    sendMsgDTO.setRoutKey(KEY_ORDER_CANCEL);
//                    mqSenderFeign.sendMessage(ORDER_TOPIC, KEY_ORDER_CANCEL, JSONUtil.toJsonStr(orderMQDTO));
                    break;
                case 4:
                    sendMsgDTO.setRoutKey(KEY_ORDER_PAY);
//                    mqSenderFeign.sendMessage(ORDER_TOPIC, KEY_ORDER_PAY, JSONUtil.toJsonStr(orderMQDTO));
                    break;
                case 6:
                    sendMsgDTO.setRoutKey(KEY_ORDER_FINLISH);
//                    mqSenderFeign.sendMessage(ORDER_TOPIC, KEY_ORDER_FINLISH, JSONUtil.toJsonStr(orderMQDTO));
                    break;
                default:
                    break;
            }
            mqSenderFeign.postSendMessage(sendMsgDTO);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    public Query initQuery(String no) {
        QueryOrderDetailDTO qodd = new QueryOrderDetailDTO();
        qodd.setCrtUser(Integer.valueOf(BaseContextHandler.getUserID()));
        qodd.setNo(no);
        qodd.setLimit(1);
        qodd.setPage(1);
        Query query = new Query(qodd);
        return query;
    }

    /**
     * 订单查询类
     */
    @Data
    public static class QueryOrderDetailDTO extends QueryOrderDTO {
        private String no;
    }
}