package com.xxfc.platform.activity.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户活动参与表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-16 14:04:22
 */
@Data
@Table(name = "activity_user_join")
public class ActivityUserJoin implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  活动规则id
     */
    @Column(name = "activity_id")
	@ApiModelProperty(value = "活动规则id")
    private Integer activityId;
	
	    /**
     *  状态：0-已参与；1-已领取
     */
    @Column(name = "status")
	@ApiModelProperty(value = "状态：0-已参与；1-已领取")
    private Integer status;
	
	    /**
     *  参与时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "参与时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  领取时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "领取时间", hidden = true )
    private Long updTime;
	

}
