package com.xxfc.platform.vehicle.feign;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.pojo.BookVehicleVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * Created by ace on 2017/9/15.
 */
@FeignClient(name = "vehicle")
public interface VehicleFeign {
    @GetMapping(value = "/vehicleModel/{id}")
    public ObjectRestResponse<VehicleModel> get(@PathVariable("id") int id);

    //修改评分
    @RequestMapping(value = "/vehicleModel/app/addScore", method = RequestMethod.GET)
    public RestResponse addScore(@RequestParam(value="id")Integer  id, @RequestParam(value="score")Integer  score);

    @RequestMapping(value = "/rent/book/vehicle", method = RequestMethod.POST)
    public ObjectRestResponse<String> rentApplyVehicle(@RequestBody BookVehicleVO bookVehicleVo);
}
