package com.xxfc.platform.vehicle.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 车型分类表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
@Table(name = "vehicle_plat_cata")
public class VehiclePlatCata implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    //主键自增字段，商品类型id
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键自增字段，商品类型id")
    private Integer id;
	
	    //父类id
    @Column(name = "parent_id")
	@ApiModelProperty(value = "父类id")
    private Integer parentId;
	
	    //名称
    @Column(name = "name")
	@ApiModelProperty(value = "名称")
    private String name;
	
	    //图标
    @Column(name = "icon")
	@ApiModelProperty(value = "图标")
    private String icon;
	
	    //描述
    @Column(name = "depict")
	@ApiModelProperty(value = "描述")
    private String depict;
	
	    //排序
    @Column(name = "rank")
	@ApiModelProperty(value = "排序")
    private Integer rank;
	
	    //级别 1:一级分类 2:二级分类...
    @Column(name = "level")
	@ApiModelProperty(value = "级别 1:一级分类 2:二级分类...")
    private Integer level;
	
	    //删除状态 0：有效 1：无效
    @Column(name = "state")
	@ApiModelProperty(value = "删除状态 0：有效 1：无效")
    private Integer state;
	
	    //创建时间
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    //更新时间
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	

}
