package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.common.msg.ListRestResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.tour.biz.TourTagBiz;
import com.xxfc.platform.tour.entity.TourBanner;
import com.xxfc.platform.tour.entity.TourTag;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("tourTag")
public class TourTagController extends BaseController<TourTagBiz,TourTag> {

    @Autowired
    private TourTagBiz tagBiz;

    @GetMapping("/app/unauth/getTagList")
    public ListRestResponse getTagList(@RequestBody Map<Object,Integer> map){

        if (map==null||map.keySet().size()==0) {
            new ListRestResponse<>().result("错误");
        }

        Integer hot = map.get("hot");



        if (hot==1){
            List<TourTag> hotTag = tagBiz.getHotTag();
            return new ListRestResponse().result(hotTag).count(hotTag.size());
        }


        PageDataVO<TourTag> all = tagBiz.findAll(map);

        return new ListRestResponse().result(all).count(all.getData().size());

    }


    @Override
    @ApiOperation("修改")
    @RequestMapping(value = "/{id}",method = RequestMethod.PUT)
    public ObjectRestResponse<TourTag> update(@RequestBody TourTag tag){
        tagBiz.update(tag);
        return new ObjectRestResponse<TourTag>();
    }



    @Override
    @ApiOperation("删除")
    @RequestMapping(value = "/{id}",method = RequestMethod.DELETE)
    public ObjectRestResponse<TourTag> remove(@PathVariable int id){
        tagBiz.remove(id);
        return new ObjectRestResponse<TourTag>();
    }



}