package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.common.msg.ListRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.tour.biz.TourTagBannerBiz;
import com.xxfc.platform.tour.entity.TourTagBanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("tourTagBanner")
public class TourTagBannerController extends BaseController<TourTagBannerBiz,TourTagBanner> {


    @Autowired

    private TourTagBannerBiz tagBannerBiz;

    @GetMapping("/app/unauth/findById/{tid}")
    public ListRestResponse findById(@PathVariable long tid){

       List<TourTagBanner> tourTagBanners = tagBannerBiz.findById(tid);
       return new ListRestResponse().result(tourTagBanners).count(tourTagBanners.size());
    }




}